/******************************************************************************
 CAdaBindTask.h

			Source File For CAdaBindTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include "CAdaBindTask.h"
#include "CAdaApp.h"
#include "CLibrary.h"
#include "AdaGlobals.h"
#include "AdaConstants.h"
#include "CFileMgr.h"
#include "CSourceDocument.h"

#include <CBartender.h>
#include <TBUtilities.h>
#include <Exceptions.h>
#include <stdio.h>
#include <stdlib.h>
#include "ErrMessages.h"


extern	OSType	gSignature;			/* Creator for Application's files	*/
extern CBartender	*gBartender;	/* Manages all menus				*/

/****
 *	IAdaBindTask
 *
 ****/
void	CAdaBindTask::IAdaBindTask(Str255 mainProg)
{
	Str255	n;

	CopyPString(mainProg, mainProgram);
	GetIndString(n, 20020, 3);
	IBkgndTask(n);
	SetPartID(kBind);
}

/****
 *	WriteOptions
 *
 ****/

void	CAdaBindTask::WriteOptions(void)
{
Str255 file;
FILE *fp;

	// Write adabing compile options to disk
	gFileMgr->GetOptionsFile(file);
	PtoCstr(file);

	_fcreator = gSignature;
	if (fp = fopen((char *)file, "w")) {
	
		// Process name (adabing)
		fprintf(fp, "%#s\n", procName);

		// Get User Library
		gLibrary->WriteOptions(fp);

		// main unit to bind
		if (mainProgram[0] > 0) {
			fprintf(fp, "-m\n");
			fprintf(fp, "%#s\n", mainProgram);

			// used for output file name (with .msg extension)
			fprintf(fp, "-c\n");
			fprintf(fp, "%#s\n", mainProgram);
		}
		fclose(fp);
	}
	else {
		// Fail opening adagen options
		Failure(errWritingOptions, 0);
	}
}

/****
 *	CompilerError
 *
 *	Binding finished with an error.  The error message is written to
 *	the msg file.  Instead of displaying the message in an alert box,
 *	open a source file with the msg file.
 *
 ****/

void	CAdaBindTask::CompilerError(void)
{
	Str255 str;
	FILE *fp;
	CSourceDocument *errors;
	FSSpec	currDoc;
	short 	wdRefNum;
	FInfo	fileInfo;
	Str255	fullMsg;
	SFReply	errorsFile;

	GetIndString(str, 20030, 2);	// Get String Binding
	ParamText(str, NULL, NULL, NULL);
	gAdaApp->FinishedBkgnd(20021, true);
/**	NoteAlert(20021, NULL);**/			// Failed

	// Deselect the currently selected window
	if (FrontWindow()) {
		CWindow *theWindow;

		theWindow = (CWindow *) GetWRefCon(FrontWindow());
		if (member(theWindow, CWindow))
			theWindow->Deactivate();
	}

	// Open document for the file (msg)
	gFileMgr->GetMsgFile(fullMsg);

	FailOSErr( FSMakeFSSpec(0, 0, fullMsg, &currDoc));
	FailOSErr( OpenWD( currDoc.vRefNum, currDoc.parID,
					gSignature, &wdRefNum));
	FailOSErr( FSpGetFInfo( &currDoc, &fileInfo));
		
	errorsFile.good = TRUE;				// this is important to set here
	errorsFile.vRefNum = wdRefNum;
	errorsFile.fType = fileInfo.fdType;
	errorsFile.version = errorsFile.copy = 0;
	CopyPString( currDoc.name, errorsFile.fName);

	errors = NULL;
	TRY
	{
		FailNIL( errors = new CSourceDocument );
		errors->ISourceDocument(gAdaApp, false);
		errors->OpenFile(&errorsFile);
	}
	CATCH
	{
		ForgetObject(errors);
		errors = NULL;
	}
	ENDTRY;

}


/****
 *	NoError()
 *
 ****/

void	CAdaBindTask::NoError(void)
{
	MenuHandle menu;

	// If we finish with SUCCESS, then...
	Str255 str;

	GetIndString(str, 20030, 2);	// Get String Binding
	ParamText(str, NULL, NULL, NULL);
	gAdaApp->FinishedBkgnd(20020, true);
/**	NoteAlert(20020, NULL);**/			// Finished Successfully

	//... update the library display	
	gLibrary->LibraryChanged();
	menu = gBartender->FindMacMenu(kBindOtherMenu);
	gLibrary->BuildBindMenu(menu);
	
	menu = gBartender->FindMacMenu(kExecuteOtherMenu);
	gLibrary->BuildExecuteMenu(menu);
}

